/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import org.luwrain.core.NullCheck;

public final class TaskCancelling {
    private volatile long id = 0L;
    private volatile boolean cancelled = false;

    public synchronized TaskId newTaskId() {
        ++this.id;
        this.cancelled = false;
        return new TaskId(this.id);
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    synchronized boolean isValidTaskId(TaskId taskId) {
        NullCheck.notNull((Object)taskId, (String)"taskId");
        return this.id == taskId.getId() && !this.cancelled;
    }

    public static final class TaskId {
        private final long id;

        public TaskId(long id) {
            if (id < 0L) {
                throw new IllegalArgumentException("id (" + String.valueOf(id) + ") may not be negative");
            }
            this.id = id;
        }

        long getId() {
            return this.id;
        }
    }
}

