/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.exceptions.ApiPrivateProfileException;
import com.vk.api.sdk.httpclient.HttpTransportClient;
import com.vk.api.sdk.objects.messages.ConversationWithMessage;
import com.vk.api.sdk.objects.messages.Message;
import com.vk.api.sdk.objects.newsfeed.NewsfeedItem;
import com.vk.api.sdk.objects.users.UserFull;
import com.vk.api.sdk.objects.wall.WallpostFull;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.RandomUtils;
import org.luwrain.app.vk.Settings;
import org.luwrain.app.vk.Strings;
import org.luwrain.app.vk.TaskCancelling;
import org.luwrain.controls.ListArea;
import org.luwrain.core.Area;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

final class Base {
    final Luwrain luwrain;
    final Strings strings;
    private final RandomUtils rand = new RandomUtils();
    private final TransportClient transportClient;
    final VkApiClient vk;
    final UserActor actor;
    final Settings sett;
    private Area[] visibleAreas = new Area[0];
    final Map<Integer, UserFull> userCache = new HashMap<Integer, UserFull>();
    final TaskCancelling taskCancelling = new TaskCancelling();
    private FutureTask task = null;
    WallpostFull[] wallPosts = new WallpostFull[0];
    UserFull shownUser = null;
    WallpostFull[] shownUserWallPosts = new WallpostFull[0];
    ConversationWithMessage[] conversations = new ConversationWithMessage[0];
    Message[] messages = new Message[0];
    UserFull[] users = new UserFull[0];
    UserFull[] friends = new UserFull[0];
    UserFull[] friendshipRequests = new UserFull[0];
    UserFull[] followings = new UserFull[0];
    UserFull[] suggestions = new UserFull[0];
    NewsfeedItem[] newsfeedItems = new NewsfeedItem[0];

    Base(Luwrain luwrain, Strings strings) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)strings, (String)"strings");
        this.luwrain = luwrain;
        this.strings = strings;
        this.sett = Settings.create(luwrain);
        this.transportClient = new HttpTransportClient();
        this.vk = new VkApiClient(this.transportClient);
        this.actor = new UserActor(Integer.valueOf(this.sett.getUserId(0)), this.sett.getAccessToken(""));
    }

    String getUserCommonName(int userId) {
        if (userId < 0 || !this.userCache.containsKey(userId)) {
            return String.valueOf(userId);
        }
        UserFull user = this.userCache.get(userId);
        return user.getFirstName() + " " + user.getLastName();
    }

    void cacheUsers(UserFull[] users) {
        NullCheck.notNullItems((Object[])users, (String)"users");
        for (UserFull u : users) {
            if (this.userCache.containsKey(u.getId())) continue;
            this.userCache.put(u.getId(), u);
        }
    }

    void setVisibleAreas(Area[] visibleAreas) {
        NullCheck.notNullItems((Object[])visibleAreas, (String)"visibleAreas");
        this.visibleAreas = (Area[])visibleAreas.clone();
    }

    boolean runTask(FutureTask task) {
        NullCheck.notNull((Object)task, (String)"task");
        if (this.isBusy()) {
            return false;
        }
        this.task = task;
        this.luwrain.executeBkg((Runnable)this.task);
        for (Area a : this.visibleAreas) {
            this.luwrain.onAreaNewBackgroundSound(a);
        }
        return true;
    }

    boolean runBkg(Operation op) {
        NullCheck.notNull((Object)op, (String)"op");
        return this.runTask(new FutureTask<Object>(() -> {
            try {
                try {
                    op.run();
                }
                catch (Exception e) {
                    this.onTaskError(e);
                }
            }
            finally {
                this.luwrain.runUiSafely(() -> this.resetTask());
            }
        }, null));
    }

    private void resetTask() {
        this.task = null;
        for (Area a : this.visibleAreas) {
            this.luwrain.onAreaNewBackgroundSound(a);
        }
    }

    boolean isBusy() {
        return this.task != null && !this.task.isDone();
    }

    void acceptTaskResult(TaskCancelling.TaskId taskId, Runnable runnable) {
        NullCheck.notNull((Object)taskId, (String)"taskId");
        NullCheck.notNull((Object)runnable, (String)"runnable");
        this.luwrain.runUiSafely(runnable);
    }

    void onTaskError(Exception e) {
        NullCheck.notNull((Object)e, (String)"e");
        if (e instanceof ApiPrivateProfileException) {
            this.luwrain.message("\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0437\u0430\u043a\u0440\u044b\u0442 \u0434\u043b\u044f \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430", Luwrain.MessageType.ERROR);
            return;
        }
        this.luwrain.crash((Throwable)e);
    }

    void closeApp() {
        this.luwrain.closeApp();
    }

    int nextRandomId() {
        Base base = this;
        return base.rand.nextInt();
    }

    ListArea.Model getConversationsListModel() {
        return new ConversationsListModel();
    }

    static interface Operation {
        public void run() throws Exception;
    }

    private final class ConversationsListModel
    implements ListArea.Model {
        private ConversationsListModel() {
        }

        public int getItemCount() {
            NullCheck.notNullItems((Object[])Base.this.conversations, (String)"conversations");
            return Base.this.conversations.length;
        }

        public Object getItem(int index) {
            NullCheck.notNullItems((Object[])Base.this.conversations, (String)"conversations");
            return Base.this.conversations[index];
        }

        public void refresh() {
        }
    }
}

