/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.news;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.news.App;
import org.luwrain.app.news.Strings;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Area;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.news.NewsGroup;

final class PropertiesLayout
extends LayoutBase {
    private static final String NAME = "name";
    private static final String ORDER_INDEX = "order-index";
    private final App app;
    final FormArea formArea;

    PropertiesLayout(App app, NewsGroup group, LayoutBase.ActionHandler closing) {
        super((AppBase)app);
        String[] urlLines;
        NullCheck.notNull((Object)group, (String)"group");
        this.app = app;
        this.formArea = new FormArea(this.getControlContext(), ((Strings)app.getStrings()).groupPropertiesAreaName(group.getName()));
        List urls = group.getUrls();
        if (urls != null && !urls.isEmpty()) {
            ArrayList<String> res = new ArrayList<String>();
            for (String s : urls) {
                res.add(s);
            }
            res.add("");
            urlLines = res.toArray(new String[res.size()]);
        } else {
            urlLines = new String[]{};
        }
        this.formArea.addEdit(NAME, ((Strings)app.getStrings()).groupPropertiesName(), group.getName());
        this.formArea.addEdit(ORDER_INDEX, ((Strings)app.getStrings()).groupPropertiesOrderIndex(), "" + group.getOrderIndex());
        this.formArea.activateMultilineEdit(((Strings)app.getStrings()).groupPropertiesUrls(), urlLines, true);
        this.setCloseHandler(closing);
        this.setOkHandler(() -> {
            if (!this.save(group)) {
                return true;
            }
            return closing.onAction();
        });
        this.setAreaLayout((Area)this.formArea, this.actions(new LayoutBase.ActionInfo[0]));
    }

    private boolean save(NewsGroup group) {
        int orderIndex;
        NullCheck.notNull((Object)group, (String)"group");
        String name = this.formArea.getEnteredText(NAME);
        if (name.trim().isEmpty()) {
            this.app.message(((Strings)this.app.getStrings()).groupPropertiesNameMayNotBeEmpty(), Luwrain.MessageType.ERROR);
            return false;
        }
        group.setName(name);
        if (this.formArea.getEnteredText(ORDER_INDEX).trim().isEmpty()) {
            this.app.message(((Strings)this.app.getStrings()).groupPropertiesInvalidOrderIndex(), Luwrain.MessageType.ERROR);
            return false;
        }
        try {
            orderIndex = Integer.parseInt(this.formArea.getEnteredText(ORDER_INDEX));
        }
        catch (NumberFormatException e) {
            this.app.message(((Strings)this.app.getStrings()).groupPropertiesInvalidOrderIndex(), Luwrain.MessageType.ERROR);
            return false;
        }
        if (orderIndex < 0) {
            this.app.message(((Strings)this.app.getStrings()).groupPropertiesInvalidOrderIndex(), Luwrain.MessageType.ERROR);
            return false;
        }
        group.setOrderIndex(orderIndex);
        ArrayList<String> urls = new ArrayList<String>();
        for (String s : this.formArea.getMultilineEditText()) {
            if (s.trim().isEmpty()) continue;
            urls.add(s.trim());
        }
        group.setUrls(urls);
        group.save();
        return true;
    }
}

