/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.news;

import java.util.Date;

class DateUtils {
    private Date now = new Date();

    DateUtils() {
    }

    public String passedTime(Date moment) {
        if (moment == null) {
            throw new NullPointerException("moment may not be null");
        }
        long wasTime = moment.getTime();
        long nowTime = this.now.getTime();
        long passed = nowTime - wasTime;
        long secondsTotal = passed / 1000L;
        long minutesTotal = secondsTotal / 60L;
        long seconds = secondsTotal - minutesTotal * 60L;
        long hoursTotal = minutesTotal / 60L;
        long minutes = minutesTotal - hoursTotal * 60L;
        long daysTotal = hoursTotal / 24L;
        long hours = hoursTotal - daysTotal * 24L;
        String res = seconds + "\u0441\u0435\u043a.";
        if (minutes > 0L) {
            res = minutes + "\u043c\u0438\u043d. " + res;
        }
        if (hours > 0L) {
            res = hours + "\u0447 " + res;
        }
        if (daysTotal > 0L) {
            res = daysTotal + "\u0434. " + res;
        }
        return res;
    }

    public static String dateTime(Date moment) {
        if (moment == null) {
            throw new NullPointerException("moment may not be null");
        }
        String res = DateUtils.addZeroes(moment.getHours(), 2) + ":" + DateUtils.addZeroes(moment.getMinutes(), 2);
        res = res + ", ";
        res = res + moment.getDate() + " " + DateUtils.month(moment.getMonth() + 1) + " " + (moment.getYear() + 1900) + "\u0433.";
        return res;
    }

    private static String month(int m) {
        switch (m) {
            case 1: {
                return "\u044f\u043d\u0432\u0430\u0440\u044f";
            }
            case 2: {
                return "\u0444\u0435\u0432\u0440\u0430\u043b\u044f";
            }
            case 3: {
                return "\u043c\u0430\u0440\u0442\u0430";
            }
            case 4: {
                return "\u0430\u043f\u0440\u0435\u043b\u044f";
            }
            case 5: {
                return "\u043c\u0430\u044f";
            }
            case 6: {
                return "\u0438\u044e\u043d\u044f";
            }
            case 7: {
                return "\u0438\u044e\u043b\u044f";
            }
            case 8: {
                return "\u0430\u0432\u0433\u0443\u0441\u0442\u0430";
            }
            case 9: {
                return "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f";
            }
            case 10: {
                return "\u043e\u043a\u0442\u044f\u0431\u0440\u044f";
            }
            case 11: {
                return "\u043d\u043e\u044f\u0431\u0440\u044f";
            }
            case 12: {
                return "\u0434\u0435\u043a\u0430\u0431\u0440\u044f";
            }
        }
        return "";
    }

    private static String addZeroes(int num, int z) {
        String res = "" + num;
        while (res.length() < z) {
            res = "0" + res;
        }
        return res;
    }
}

