/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.news;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.news.Conv;
import org.luwrain.app.news.GroupWrapper;
import org.luwrain.app.news.MainLayout;
import org.luwrain.app.news.Strings;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.MonoApp;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.pim.news.NewsArticle;
import org.luwrain.pim.news.NewsGroup;
import org.luwrain.pim.news.NewsStoring;
import org.luwrain.pim.workers.News;

public final class App
extends AppBase<Strings>
implements MonoApp {
    private NewsStoring storing = null;
    private MainLayout mainLayout = null;
    private Conv conv = null;
    private NewsGroup group = null;
    boolean showAllGroups = false;
    final List<GroupWrapper> groups = new ArrayList<GroupWrapper>();
    final List<NewsArticle> articles = new ArrayList<NewsArticle>();

    public App() {
        super(Strings.class, "luwrain.news");
    }

    public AreaLayout onAppInit() throws Exception {
        this.storing = null;
        if (this.storing == null) {
            throw new Exception("No news storing");
        }
        this.conv = new Conv(this);
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        this.loadGroups();
        this.runFetching();
        return this.mainLayout.getAreaLayout();
    }

    boolean openGroup(NewsGroup newGroup) {
        NullCheck.notNull((Object)newGroup, (String)"newGroup");
        this.group = newGroup;
        this.loadArticles();
        return true;
    }

    void loadGroups() {
        ArrayList<GroupWrapper> w = new ArrayList<GroupWrapper>();
        Object[] g = this.storing.getGroups().load();
        Arrays.sort(g);
        int[] newCounts = this.storing.getArticles().countNewInGroups((NewsGroup[])g);
        int[] markedCounts = this.storing.getArticles().countMarkedInGroups((NewsGroup[])g);
        for (int i = 0; i < g.length; ++i) {
            int markedCount;
            int newCount = i < newCounts.length ? newCounts[i] : 0;
            int n = markedCount = i < markedCounts.length ? markedCounts[i] : 0;
            if (!this.showAllGroups && newCount <= 0 && markedCount <= 0) continue;
            w.add(new GroupWrapper((NewsGroup)g[i], newCount));
        }
        this.groups.clear();
        this.groups.addAll(w);
    }

    void loadArticles() {
        if (this.group == null) {
            this.articles.clear();
            return;
        }
        this.articles.clear();
        this.articles.addAll(Arrays.asList(this.storing.getArticles().loadWithoutRead(this.group)));
        if (this.articles.isEmpty()) {
            this.articles.addAll(Arrays.asList(this.storing.getArticles().load(this.group)));
        }
        if (this.articles != null) {
            Collections.sort(this.articles);
        }
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public boolean onSystemEvent(Area area, SystemEvent event) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(area, event);
        }
        switch (event.getCode()) {
            case REFRESH: {
                this.runFetching();
                return true;
            }
        }
        return super.onSystemEvent(area, event);
    }

    void runFetching() {
        this.getLuwrain().runWorker(News.NAME);
    }

    public MonoApp.Result onMonoAppSecondInstance(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        this.runFetching();
        return MonoApp.Result.BRING_FOREGROUND;
    }

    Conv getConv() {
        return this.conv;
    }

    NewsStoring getStoring() {
        return this.storing;
    }
}

